#### Application type
## Instruction
Please select "Non-Research/Other > Outline Application" if you are applying for a (non-research) grant via a funding scheme operating a multi application process. This will typically involve an initial draft application which may require basic details regarding costs for example, but which if "successful" will lead to a further more in depth application.
## Example
If you were applying to the European Commission for a 'Capacity Building in Higher Education' grant, or to the British Council's 'DICE' Fund, then you'd enter these details under the 'Non-Research/Other' category. If an 'Expression of Interest' or 'outline' application is required by the funder initially, then the details of that should be recorded under the "Non-Research/Other > Outline Application".
#### Nature of activity type
## Instruction
Not being used currently, so please ignore.
## Example
n/a
#### Title
## Instruction
Please enter the full title of your Non-Research/Other Grant application.
## Example
n/a
#### Short title
## Instruction
Please enter the short title of your Non-Research/Other Grant application, if applicable.
## Example
n/a
#### Acronym
## Instruction
Please enter the acronym of your Non-Research/Other Grant application, if applicable.
## Example
n/a
#### Description
## Instruction
Please enter a short description of your Non-Research/Other Grant application, if applicable.
## Example
n/a
#### IPR/Confidentiality
## Instruction
Please enter a short description of any concerns regarding IPR/Confidentiality. If the field is left blank then that will be taken as a "none".
## Example
n/a
#### Conflict of interest
## Instruction
Please enter a short description of any concerns regarding Conflict of Interest. If the field is left blank then that will be taken as a "none".
## Example
n/a
#### IDs > Funder Reference
## Instruction
Please enter the funder's reference for your application if known/applicable.
## Example
n/a
#### IDs > RIO ID
## Instruction
Please ignore this field - the RIO ID will be entered here by RIO once fully authorised.
## Example
n/a
#### IDs > Finance Account No.
## Instruction
Please ignore this field - the Finance Account No. will be entered here by Finance or RIO once fully authorised.
## Example
n/a
#### IDs > School Reference
## Instruction
Please ignore this field - your Research Advisor or equivalent will enter a reference here for their own records if applicable.
## Example
n/a
#### Related funding applicants
## Instruction
PI and Co-Is are entered here, with their organisations populating as per the data held with PURE. The details entered here should match the applicants recorded on the application. Please use the "Role" dropdown to select each applicant's role of either "PI" or "Co-I".

If GCU are the lead applicant on an application with multiple applicants/collaborators, then please indicate the relevant GCU academic as the PI. If GCU are not the lead but are a Co-Applicant, then please enter the lead GCU academic first, but select their role as Co-I, followed by any other Co-Is. Please also include as PI, the external applicant who is the lead as per the application.
## Example
If GCU are the lead and there are 3 external partners, then the GCU lead academic should be noted first and have a 'Role' of 'PI'. Any other GCU Co-Is should be noted also, and so too should the Co-Is from the 3 external partners - especially if the external partners are receiving funding.

If GCU are not the lead applicant, then as a minimum, the GCU lead academic should be recorded first with a 'Role' of 'Co-I'. Any other GCU applicants should be added at this point, and so too should the actual lead academic of the project. Although they are an external partner they should be given the 'Role' of 'PI' if this matches the application.
#### Managing organisational unit
## Instruction
Select the GCU lead academic's subject/department. This should be the first and potentially only item in the list.
## Example
The 'Managing organisational unit' is based on the lead GCU academic's subject/department e.g. History.
#### Collaborative application
## Instruction
Select "Yes" if there are applicants from multiple institutions and/or if there is another non applicant partner (industry partner for example). Selecting "No" will prevent the allocation of funds to other parties (institutions or partners) in the "Fundings" screen.
## Example
Selecting "yes" will allow for additional organisations to be shown as applicants or partners, and this needs to be the case to allocate funds between all organisations applying.

If it is only GCU staff applying then "No" can be chosen, and no other organisation will be listed as part of the application.
#### Collaborators
## Instruction
If "Yes" was selected in the "Collaborative application" field, then this is where collaborating organisations should be recorded. Applicants should be as per the application, with collaborators (but not applicants, e.g. industry partners) recorded as "project partners".
## Example
Other institutions or organisations would be shown here if applicable, e.g. The University of Strathclyde if they were PI or Co-I on a grant GCU was also involved with.
#### Funding opportunity
## Instruction
Please ignore this field.
## Example
n/a
#### Fundings > Funding organisation
## Instruction
This field is for indicating the funding body being applied to. More than one funding body can be entered if appropriate, so if there is funding from a 3rd party being contributed to the project, then they too will need added separately.
## Example
If the Non-Research/Other Grant application is being made to the British Council, then that's the funding body that should be noted here.
#### Fundings > Higher Education Statistics Agency (HESA) Types
## Instruction
Please choose the relevant HESA Code for each funding body, with this info required for both internal and external reporting.

Further details can be found directly from the HESA site:
https://www.hesa.ac.uk/support/definitions/finances
## Example
For example, if your Non-Research/Other Grant application is being made to the European Commission, then the correct HESA Code would be "EU government bodies".
#### Fundings > REF income sources
## Instruction
Please ignore this field, it will update automatically based on the HESA Code entry when the application is saved.
## Example
n/a
#### Fundings > Funding organisation size
## Instruction
Please choose the appropriate size for the funder.
## Example
For example, if your Non-Research/Other Grant application is being made to the European Commission, then the correct organisation size would be "Other Organisation (government, charities etc)".
#### Fundings > Funding organisation type
## Instruction
Please choose the appropriate location of the funder.
## Example
For example, if your Non-Research/Other Grant application is being made to the European Commission, then the correct organisation location would be "EU Based".
#### Fundings > Funding project scheme (research programme)
## Instruction
Although not mandatory, it'd be useful to enter the funding body's funding scheme here, if applicable.
## Example
For example, "ERASMUS+ Call for proposals 2020  |  Call ID: EAC-A02-2019-T" is a funding call for a capacity building project.
#### Fundings > Cost code
## Instruction
*** To be hidden ***
## Example
n/a
#### Fundings > Financial summary > Financial
## Instruction
The default selection is "Financial" and this would only need changed if non-financial i.e. in-kind values/data was being entered. If a funder is providing both financial and non-financial support then they would need added as a funder twice - one for each type of support.
## Example
If an industry partner was contributing £1,000 to a project, then they would be included as a funder with this funding recorded. If they also were providing £500 of in-kind support (e.g. equipment usage), then they would be added as a funder again separately, the 'non-financial' button would need ticked, then the 'in-kind' contribution details would be added.
#### Fundings > Financial summary > Applied amount in applied currency
## Instruction
If the application is being made in a currency other than GBP, please indicate the currency here and the amount in that currency being applied for.
## Example
If your application is being made to the European Commission then you'd enter the Euro equivalent figure and select the currency as "EUR - Euros". The GBP figure is required elsewhere.
#### Fundings > Financial summary > Applied amount
## Instruction
This field is for stating the total amount being applied for, i.e. the amount the funder would award to all applicants if successful. The value here may or may not match the  amount for GCU, but should match the amount on the application.
## Example
If the application is requesting £20,000, then despite GCU's Full Economic Cost potentially being higher; or despite GCU's share being potentially lower, £20,000 is still the 'Applied Amount'.
#### Fundings > Financial summary > Estimated value
## Instruction
This field is for stating the cash value of the 'in-kind' or otherwise non-financial contribution being requested.
## Example
If an industry partner was contributing £500 of in-kind support (e.g. equipment usage), then the value of £500 would be stated here.
#### Fundings > Financial summary > Description
## Instruction
This field is for providing details of the type of 'in-kind' or otherwise non-financial, contribution being requested.
## Example
If an industry partner was contributing £500 of in-kind support (e.g. equipment usage), then a description of the support would be required here.
#### Fundings > Split between the collaborative partners > Institutional part
## Instruction
This is the funding/income for GCU if the application is successful. funding/income for other partners is recorded elsewhere.
## Example
If GCU and another organisation are requesting £50,000 in total from a funder, but GCU's share is only £15,000, then it's this value, the £15,000, that's recorded in this field.
#### Fundings > Split between the collaborative partners > Institutional contribution
## Instruction
If GCU are contributing a specific set of funds to a project, then this would be entered here.
## Example
There are funding schemes which if successful in applying to, require the applicant to contribute funds, such as some studentships for which the costs are shared between the funder and GCU.
#### Fundings > Split between the collaborative partners > Institutional fEC
## Instruction
This is the cost to GCU of carrying out the project. This will typically be a figure from a Costing spreadsheet and should at least match the income to GCU, but will often be higher.
## Example
An application to the European Commission for £50,000 could have a Full Economic Cost of £125,000, and it's this figure that should be entered here. Please refer to the Costing spreadsheet and contact rie.costings@gcu.ac.uk for further advice.
#### Fundings > Split between the collaborative partners > fEC %
## Instruction
*** To be hidden ***

If unable to be hidden then "Please leave blank" could be used.
## Example
n/a
#### Fundings > Split between the collaborative partners > Institutional estimated value
## Instruction
If the funder is offering in-kind support then the cash value for GCU would be noted first, with any in-kind support for partner organisations detailed below. If GCU are showing separately, i.e. as "Glasgow Caledonian University - external organisation", then this should be left blank, as GCUs in-kind support is noted in the first field.
## Example
For example, if a funder is hosting a stakeholder or dissemination meeting and covering the cost of this themselves (room hire and catering etc), then they could consider this an in-kind cost. Each applicant could benefit equally or according to the number of attendees.
#### Deadline
## Instruction
Please state the deadline for submission of the application here.
## Example
If the funder's deadline is 31st July '20 for example, please indicate this here. When considering deadlines, please remember that your application record on PURE requires approval by your Research Advisor or equivalent; RIO; and then Cam, before you should submit the application.
#### Date submitted
## Instruction
This will likely be blank, as applications shouldn't be submitted until fully approved via this process, but RIO will complete this field when applications are submitted by RIO. For applications submitted by the GCU lead academic, or the external PI, the GCU lead should update this field once known. RIO and the Research Advisors will check periodically to ensure this field is completed.
## Example
For Non-Research/Other applications, RIO will complete this field where possible but if not the  GCU Lead should.
#### Funder reply
## Instruction
This will likely be recorded as "Pending", as the result of the application may not be known at the point of entering the application details on PURE. Once the result is known and contract agreed, RIO who will update this to "Successful" or "Unsuccessful" accordingly.

For Outline applications, if the result is moving on to the next stage, then "Copy" the original application to create a new one, amend the details as necessary (e.g. new deadline, new costs, new duration) but keep the same RIO ID. The original record on PURE should now be "Aborted".
## Example
For applications to the European Commission for example, RIO don't have to approve the online application and so the GCU Lead will need to update the submitted date once known.
#### Exp. start date
## Instruction
Please enter the expected start date of the project, remembering that the start date of the costing and the application should match this date.
## Example
Please enter the start date of the project, taking into account the funder's guidance and requirements e.g. for the CSO, the start date must always be the 1st of a month.
#### Exp. end date
## Instruction
Please enter the expected end date of the project, remembering that the end date of the costing and the application should match this date.
## Example
Please enter the end date of the project, taking into account the funder's guidance and requirements.
#### File title
## Instruction
There will typically be a number of documents to upload as part of an application, such as the PIF; the final costing; a signed risk register; and a copy of the application. The title will default to the name of the document, but feel free to enter a different one.
## Example
For example, you may have had 6 costings done and instead of the title matching the document name you could have "Final Costing" instead of "AMcK Wellcome Trust 01/01/2020 v6 Costing". Neither would be incorrect however.
#### Type
## Instruction
Please choose an applicable document type (or the most appropriate) for the document from the available options.
## Example
For example, if you are uploading the PIF, please choose the "Project Initiation Form (PIF)" type.
#### Web address (URL)
## Instruction
It isn't mandatory but please enter a link to any website you believe appropriate i.e. the funding call.
## Example
If for example you are applying for a "Horizon 2020 Grant" from the European Commission, you could enter a link to the specific call.
#### Description
## Instruction
If a link to a website was entered previously, please note a short description here.
## Example
If the link was to the funding call for example, you could indicate that here.
#### Link type
## Instruction
If a link to a website was entered previously, please select the type of link here.
## Example
If the link was to the funding call for example, you could indicate that here.
#### Related project
## Instruction
If a Project record exists on PURE to which this application relates, then please link to it from here. Project records hold the basic details of Application and Award records, and allow for the grouping of related records. This isn't mandatory though at this point, and records can be linked at a later date.
## Example
For example, Outline application records can be linked to Project records, and so too would the Full Application and subsequent Award records if successful. Project records can also be created to link associated Application and Award records on the basis of Funder or Funding scheme for example.
#### Related applications
## Instruction
If another Application record exists on PURE to which this application relates, then please link to it from here. Typically though, the only other Application record that an Outline Application would be linked to would be the Full version of the application. If an academic wanted to link multiple application records on the basis of funder for example, that would be done by linking to a Project record.
## Example
For example, Outline application records can be linked to Full application records, and subsequent Award records if successful.
#### Award relations
## Instruction
If an Award record exists on PURE to which this application relates, then please link to it from here. Typically though the associated Award record will be created once the application is successful and therefore linked at that time, so linking to an Award at this stage is unlikely to be required.
## Example
n/a
#### Related ethical reviews
## Instruction
This isn't used at present so please ignore.
## Example
n/a
#### Sustainable Development Goals
## Instruction
Please choose at least one but multiple are allowed and encouraged where appropriate.
## Example
If the Non-Research/Other grant application is to fund a capacity building project, then "Partnerships" could be used.
#### Keywords
## Instruction
This isn't used at present so please ignore.
## Example
n/a
#### Visibility
## Instruction
All application records are confidential, and only if awarded would a further discussion take place for the visibility of Award and Project records.
## Example
Publicly available - e.g. website/portal
Campus (IP) - from allowed IP-addresses
Restricted to Pure-users - Only visible when logged in to Pure.
Confidential - Only visible when logged into Pure and only for contributors and users with editorial rights to the content


